/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.actions;

import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.github.IGithubPullRequest;
import com.aptana.git.core.github.IGithubRepository;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.ui.internal.actions.AbstractGithubHandler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;

public class MergePullRequestItem
extends CompoundContributionItem
implements IWorkbenchContribution {
    protected static final IContributionItem[] NO_CONTRIBUTION_ITEMS = new IContributionItem[0];
    private IServiceLocator serviceLocator;

    public MergePullRequestItem() {
    }

    public MergePullRequestItem(String id) {
        super(id);
    }

    protected IGitRepositoryManager getGitRepositoryManager() {
        return GitPlugin.getDefault().getGitRepositoryManager();
    }

    protected IResource getSelectedResource() {
        IEvaluationService evalService = (IEvaluationService)this.serviceLocator.getService(IEvaluationService.class);
        if (evalService != null) {
            IEvaluationContext context = evalService.getCurrentState();
            IWorkbenchPart activePart = (IWorkbenchPart)context.getVariable("activePart");
            if (activePart instanceof IEditorPart) {
                IEditorInput input = (IEditorInput)context.getVariable("activeEditorInput");
                return (IResource)input.getAdapter(IResource.class);
            }
            ISelection selection = (ISelection)context.getVariable("selection");
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection struct = (IStructuredSelection)selection;
                Object firstElement = struct.getFirstElement();
                if (firstElement instanceof IResource) {
                    return (IResource)firstElement;
                }
                if (firstElement instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)firstElement;
                    return (IResource)adaptable.getAdapter(IResource.class);
                }
            }
        }
        return null;
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    protected IContributionItem[] getContributionItems() {
        IResource resource = this.getSelectedResource();
        if (resource == null) {
            return NO_CONTRIBUTION_ITEMS;
        }
        GitRepository repo = this.getGitRepositoryManager().getAttached(resource.getProject());
        if (repo == null) {
            return NO_CONTRIBUTION_ITEMS;
        }
        try {
            IGithubRepository ghRepo = repo.getGithubRepo();
            List prs = ghRepo.getOpenPullRequests();
            ArrayList<MergePullRequestContributionItem> contributions = new ArrayList<MergePullRequestContributionItem>(prs.size());
            for (IGithubPullRequest pr : prs) {
                contributions.add(new MergePullRequestContributionItem(repo, pr));
            }
            return contributions.toArray(new IContributionItem[contributions.size()]);
        }
        catch (CoreException e) {
            return NO_CONTRIBUTION_ITEMS;
        }
    }

    private static class MergePullRequestContributionItem
    extends ContributionItem {
        private final IGithubPullRequest pr;
        private final GitRepository repo;

        MergePullRequestContributionItem(GitRepository repo, IGithubPullRequest pr) {
            this.repo = repo;
            this.pr = pr;
        }

        public void fill(Menu menu, int index) {
            MenuItem menuItem = new MenuItem(menu, 8, index++);
            menuItem.setText(this.pr.getDisplayString());
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractGithubHandler.mergePullRequest(MergePullRequestContributionItem.this.repo, MergePullRequestContributionItem.this.pr);
                }
            });
        }
    }
}

